function [seam] = Horizontal_Seam(image)

%compute energy map
M = imenergy(image);

%find image dimensions
dim = size(M);
rows = dim(1);
cols = dim(2);

%make a map that records the cummulatibe weight and the next element in
%the shortest path
map = [rows : cols : 2];

%initialize the last column
for  i = 1 : rows
    map(i, cols, 1) = M(i,cols, 1);
end

%Move right to left and compute the least weightd path
for  i = cols - 1 : -1 :  1
    for  j = 1 : rows
        
        weight = M(j,i) + map(j ,i+1);
        index = (j);
        
        if j ~= 1
            up = M(j,i) + map(j - 1 ,i+1);
            if (up < weight)
                weight = up;
                index = j-1;
            end
        end
        
        if j ~= rows
            down = M(j,i) + map(j + 1 ,i+1);
            if (down < weight)
                weight = down;
                index = j+1;
            end    
        end
        
        map(j,i,1) = weight;
        map(j,i,2) = index;
    end
end


start = 1;
%find the starting point for the least weighted seam
for i = 1 : rows
    if map(i,1,1) < map(start,1,1)
        start = i;
    end
end

%create vector to represent the seam
seam = [cols];
current = start;
seam(1) = start;

%record the best seam in the seam vector
for i = 1 : cols - 1
    
   seam(i+1) = map(current,i,2);
   current = map(current,i,2);
  
end








